libname rcs 'C:\stats\RMC06';
data rcs.rural_dsorted_short;
* all the calculations are per route;
set rcs.rmc_06_LONG;
where miles>1;
where BOXESR + BOXESC >0;
where letters>0;
WHERE TOTMIN>0;
where ((ACTLHRS*6)- (TEVHRS*6))< 16.66 AND ((TEVHRS*6) - (ACTLHRS*6))< 16.66;
* From initial 73,144 observations, 71,224 observations
remained- 1900 obs (2.6% of the initial nr of observations)
have been deleted according to the editing procedure outlined in
RURAL DELIVERY AND THE UNIVERSAL SERVICE OBLIGATION:
A QUANTITATIVE INVESTIGATION, 1993, Cohen et al, Appendix A, p.23
(Also, the Postal Service performed a similar edit on the sample of routes
selected for measuring the elasticity of rural carrier costs. Docket R90-1,
USPS-T-13, Appendix F, p. F-8.)
The last condition states that the difference between weekly actual and evaluated time
should not be greater than 1,000 minutes (16.66 hours);

density= TBOXES/MILES;
* number of stand-alone and centralized boxes per mile per route;
proc sort data= rcs.rural_dsorted_short;
by density;
* sorted by density from least dense;
run;
data rcs.rural_dsorted_short_AVG;
set rcs.rural_dsorted_short;
LC_H=32.617285;    *RURAL CARRIER LABOR COST PER EVALUATED HOUR IN 2006&2007*;
PGBFCTR=1.24296775;  *RURAL CARRIER PIGGYBACK FACTOR FOR SUPERVISION,
                      SPACE AND SPACE RELATED COSTS FROM ACR2007-1*;

LC_MIN=LC_H/60; *RURAL CARRIER LABOR COST PER EVALUATED MINUTE*;                

BOXESRLC_R = BOXESRT * LC_MIN;  
*DIRECT LABOR COST TO DELIVER TO STAND-ALONE BOXES PER ROUTE PER DAY;
* BOXESRT is the time to deliver to each stand-alone box (minutes/day);
BOXESROHLC_R =  BOXESRLC_R*(PGBFCTR-1); 
*RURAL CARRIER OVERHEAD COST  TO DELIVER TO STAND-ALONE BOXES PER ROUTE PER DAY*;
BOXESRDC_R = BOXESRLC_R + BOXESROHLC_R; 
*TOTAL DELIVERY COST TO STAND-ALONE BOXES PER ROUTE PER DAY*;


IF BOXESR> 0 THEN delcost_boxesR =  BOXESRDC_R/BOXESR;    
* average delivery cost to a stand-alone box per rural route in 2006&2007;

BOXESCLC_R = BOXESCT * LC_MIN;  
*DIRECT LABOR COST TO DELIVER TO A CENTRALIZED BOX PER ROUTE PER DAY;
* BOXESCT is the time to deliver to each CENTRALIZED box (minutes/day);
BOXESCOHLC_R =  BOXESCLC_R*(PGBFCTR-1); 
*RURAL CARRIER OVERHEAD COST  TO DELIVER TO CENTRALIZED BOXES PER ROUTE PER DAY*;
BOXESCDC_R = BOXESCLC_R + BOXESCOHLC_R; 
*TOTAL DELIVERY COST TO CENTRALIZED BOXES PER ROUTE PER DAY*;

IF BOXESC> 0 THEN delcost_boxesC =  BOXESCDC_R/BOXESC;    
* average delivery cost to a centralized box per rural route in 2006&2007;

efficiency_centralized= (delcost_boxesc/delcost_boxesr)*100;
* the cost efficiency factor of delivering to a centralized box vs.
a stand-alone box (in percentage);

TEVMNBOXES= BOXESRT + BOXESCT;
* TOTAL evaluated time to deliver to stand-alone and centralized boxes per route-day (min);
IF TBOXES>0 THEN EVALMN_BOX= TEVMNBOXES/TBOXES;
* daily evaluated time per box (stand alone and centralized) per route (min);

run;
DATA rcs.rural_dsorted_short_AVG;
set rcs.rural_dsorted_short_AVG;

/*  Variables describing the number of retail transactions

	MONORDR	Number of money orders
	LETCOLL	Number of letter size pieces collected
	PARCACC	Number of parcel posts accepted  
	REGACC	Number of registrd, cert., collected on route
	RETRCT	Number of return receipts*/

	*TOTAL DAILY RETAIL TRANSACTIONS PER ROUTE ***;
RETAILTRZ = MONORDR+LETCOLL+PARCACC+REGACC+RETRCT;

*IF RETAILTRZ=0 THEN RETAILTRZ=1;  *TO PREVENT DIVIDING BY ZERO*;
* statement REPLACED BY  (IF RETAILTRZ> 0 THEN FORMULA);

/*  Variables describing office time on retail transactions

	RETRCTT	Time handling return receipts 
	MNORDOT	Time for Money orders, office time  
	PPACCOT	Time accepting parcel posts, office time   
	STAMPST	Purchasing stamps for the route
	ALLOWT	Other suitable allowances*/
	
** RETAIL DAILY OFFICE MINUTES PER ROUTE ***;            

EVMNORTL = RETRCTT+MNORDOT+PPACCOT+STAMPST+ALLOWT;

/*  Variables describing street time on retail transactions

	DISMNTT	Time for dismounts
	COLLFT	Time collecting letter size pieces  
	MNORDRT	Time for Money orders, route time 
	PPACCRT	Time for parcel posts accepted, route time  
	COLREGT	Collecting registered, certified, etc.*/  

***RETAIL DAILY STREET MINUTES PER ROUTE ***;

EVMNRRTL = DISMNTT+COLLFT+MNORDRT+PPACCRT+COLREGT;

**TOTAL DAILY RETAIL MINUTES PER ROUTE ***;
TEVMNRTL=EVMNORTL+EVMNRRTL;

IF RETAILTRZ>0 THEN EVMNORTL_TRZ = EVMNORTL/RETAILTRZ;   
*OFFICE RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
IF RETAILTRZ>0 THEN EVMNRRTL_TRZ = EVMNRRTL/RETAILTRZ;   
*STREET RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
IF RETAILTRZ>0 THEN TEVMNRTL_TRZ = TEVMNRTL/RETAILTRZ;   
*RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
RUN;
DATA rcs.rural_dsorted_short_AVG;
SET rcs.rural_dsorted_short_AVG;
**  CALCULATE RETAIL DELIVERY COST ***;

LC_MIN=LC_H/60; *RURAL CARRIER LABOR COST PER EVALUATED MINUTE*;                

RETAILLC_R   =  TEVMNRTL*LC_MIN;         
*RETAIL DIRECT LABOR COST PER RURAL ROUTE PER DAY*;
RETAILOHLC_R =  RETAILLC_R*(PGBFCTR-1);      
*RURAL CARRIER OVERHEAD COST PER ROUTE PER DAY*;
* changed from LC_MIN to RETAILLC_R in the above formula;
RETAILDC_R   =  RETAILLC_R+RETAILOHLC_R; 
*TOTAL DELIVERY RETAIL COST PER ROUTE PER DAY*;
IF RETAILTRZ>0 THEN RETAILDC_TRZ =  RETAILDC_R/RETAILTRZ;    
*RETAIL COST PER RETAIL TRANSACTION PER DAY*;

RUN;
proc means data= rcs.rural_dsorted_short_AVG MEAN;
VAR TEVHRS BOXESR BOXESC TBOXES MILES DENSITY 
delcost_boxesR delcost_boxesC efficiency_centralized
RETAILDC_TRZ EVALMN_BOX profit;
* average of a number of variables (including average delivery cost per standard box,
per centralized box, and per retail tranzaction) for all the cleaned data,
according to density (from the least dense);
RUN;

